﻿using Microscopic_Traffic_Simulator.ViewModels;
using Microscopic_Traffic_Simulator.Views.SettingsView;
using System.Windows;
using System.Windows.Controls;
using System.Windows.Data;

namespace Microscopic_Traffic_Simulator.Views.MainWindowView
{
    /// <summary>
    /// Interaction logic for ConstructionUserControl.xaml
    /// </summary>
    public partial class ConstructionUserControl : UserControl
    {
        /// <summary>
        /// Initialization of control.
        /// </summary>
        public ConstructionUserControl()
        {
            InitializeComponent();
        }

        /// <summary>
        /// Event receiver for showing up dialog with parameters settings.
        /// </summary>
        /// <param name="sender">Sender object.</param>
        /// <param name="e">Not used event args.</param>
        private void ButtonInitializeSimulation_Click(object sender, RoutedEventArgs e)
        {
            MainWindow mainWindow = Window.GetWindow(this) as MainWindow;
            mainWindow.canvasUserControl.RoadPreviewer.ClearPreviewOfBuildingOfAnyRoads();
            ParametersWindow parametersWindow = new ParametersWindow();
            parametersWindow.DataContext = (mainWindow.DataContext as MainViewModel).GetParametersViewModel();
            bool? result = parametersWindow.ShowDialog();
            if (result.HasValue && result.Value)
            {
                mainWindow.canvasUserControl.SimulationTrafficRenderer.CellularTopology = (mainWindow
                    .canvasUserControl.DataContext as CanvasViewModel).CellularTopology;
                mainWindow.canvasUserControl.SimulationTrafficRenderer.AttachEventHandlerFromCellularTopology();
            }
        }

        /// <summary>
        /// Event handler for events when data source target of the lane-type radio button is udpated.
        /// </summary>
        /// <param name="sender">Not used sender referenence.</param>
        /// <param name="e">Not used event args.</param>
        private void RadioButton_SourceUpdated(object sender, DataTransferEventArgs e)
        {
            (Window.GetWindow(this) as MainWindow).canvasUserControl.RoadPreviewer.LaneTypeWasChanged();
        }

        private void generatorBuildingModeButton_Unchecked(object sender, RoutedEventArgs e)
        {
            MainWindow mainWindow = Window.GetWindow(this) as MainWindow;
            if (mainWindow != null)
            {
                mainWindow.canvasUserControl.GeneratorPossibleLocationsRenderer.Clear();
            }
        }

        private void laneBuildingModeButton_Unchecked(object sender, RoutedEventArgs e)
        {
            MainWindow mainWindow = Window.GetWindow(this) as MainWindow;
            if (mainWindow != null)
            {
                mainWindow.canvasUserControl.RoadPreviewer.ClearPreviewOfBuildingOfAnyRoads();
            }
        }

        private void generatorBuildingModeButton_Checked(object sender, RoutedEventArgs e)
        {
            (Window.GetWindow(this) as MainWindow).canvasUserControl.GeneratorPossibleLocationsRenderer
                .RenderPossibleLocations();
        }
    }
}
